#!/bin/bash

LOG_FILE="/var/log/ins_webmin.log"
export DEBIAN_FRONTEND=noninteractive


echo "Starting Webmin installation..." >> "$LOG_FILE" 2>&1

# Detect if system is Red Hat/CentOS
if [ -f /etc/redhat-release ]; then
    cd /root || exit

    # Install prerequisites
     dnf update -y

    # Download official Webmin repo
    curl -o webmin-setup-repo.sh https://raw.githubusercontent.com/webmin/webmin/master/webmin-setup-repo.sh >> "$LOG_FILE" 2>&1
    sh webmin-setup-repo.sh

    # Install Webmin
    
    dnf install -y webmin >> "$LOG_FILE" 2>&1

# Else assume Debian/Ubuntu
else
    cd /root || exit
    apt-get -y update

    # Add official Webmin GPG key
    curl -o webmin-setup-repo.sh https://raw.githubusercontent.com/webmin/webmin/master/webmin-setup-repo.sh >> "$LOG_FILE" 2>&1
    yes | sh webmin-setup-repo.sh

    # Update and install
    apt-get update >> "$LOG_FILE" 2>&1
    apt-get install -y webmin  --install-recommends >> "$LOG_FILE" 2>&1
fi

# Cleanup
echo "Webmin installation completed." >> "$LOG_FILE" 2>&1
exit 0
