#!/bin/bash

set -euo pipefail
shopt -s inherit_errexit

if [[ -f /var/lib/oct/.application-installed ]]; then
	echo "Application script completion detected - not re-running"
	exit 0
fi

. /opt/oct-installer/common.sh

########
echo "Setting variables"
########
php_version="8.2"

########
echo "Disable unattended upgrades while configuring app"
########
toggle_unattended_upgrades "disable"

########
echo "Install and configure SQL Database"
########
install_mysql "${mysql_ibps:-"0"}" "${mysql_toc:-"0"}"
systemctl enable --now mariadb.service

########
echo "Install and configure PHP"
########
install_php "${php_version}" "optimize"

########
echo "Install and configure NGINX"
########
install_nginx
mv /opt/oct-installer/index.php /usr/share/nginx/html/
mv /opt/oct-installer/http* /etc/nginx/sites-available/
ln -s /etc/nginx/sites-{available,enabled}/http.conf
ln -s /etc/nginx/sites-{available,enabled}/https.conf

########
echo "Generate TLS certificates"
########
generate_self_signed_cert

########
echo "Remove any remaining unnecessary packages"
########
autoremove_packages

########
echo "Re-enable unattended upgrades as app is configured"
########
toggle_unattended_upgrades "enable"

########
echo "Enable services"
########
systemctl enable --now "php${php_version}-fpm.service" nginx.service

########
echo "Cleanup the environment"
########
cleanup_imageless