<?php ?>
<!DOCTYPE html>
<html lang="en-us">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta content="width=device-width,initial-scale=1.0,minimum-scale=1.0,maximum-scale=5.0" name=viewport>
        <title>Bienvenue sur votre nouveau site web hébergé par Octenium</title>
        <meta name="description" content="Bienvenue sur votre nouveau site web hébergé par Octenium"/>
        <meta name="keywords" content="octenium, hébergement web, nom de domaine en Algérie"/>
        <meta itemprop="name" content="Bienvenue sur votre nouveau site web hébergé par Octenium"/>
        <meta itemprop="description" content="Bienvenue sur votre nouveau site web hébergé par Octenium."/>
        <meta property="og:title" content="Bienvenue sur votre nouveau site web hébergé par Octenium"/>
        <meta property="og:description" content="Bienvenue sur votre nouveau site web hébergé par Octenium."/>
        <meta property="og:type" content="website"/>
        <meta property="og:image" content="https://cdn.octenium.com/media/logo/400x400-blue.png"/>
        <meta name="twitter:card" content="summary"/>
        <meta name="twitter:site" content="@octenium"/>
        <meta name="twitter:title" content="Bienvenue sur votre nouveau site web hébergé par Octenium"/>
        <meta name="twitter:description" content="Bienvenue sur votre nouveau site web hébergé par Octenium."/>
        <meta name="twitter:image" content="https://cdn.octenium.com/media/logo/400x400-blue.png"/>
        <!-- Bootstrap 4 -->
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css" integrity="sha384-Vkoo8x4CGsO3+Hhxv8T/Q5PaXtkKtu6ug5TOeNV6gBiFeWPGFN9MuhOf23Q9Ifjh" crossorigin="anonymous">
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

        <style type="text/css">
            html, body {
                font-family: 'Roboto', sans-serif;
                font-size: 0.85vw;
                -ms-text-size-adjust: 100%;
                -webkit-text-size-adjust: 100%;
                background-color: white;
                -webkit-font-smoothing: antialiased;
            }

            body {
                margin: 0;
                padding: 0;
                display: flex;
                display: -webkit-box;
                display: -ms-flexbox;
                -webkit-box-orient: vertical;
                -webkit-box-direction: normal;
                -ms-flex-direction: column;
                flex-direction: column;
                align-items: center;
                -webkit-box-align: center;
                -moz-box-align: center;
                -ms-flex-align: center;
                -webkit-align-items: center;
                justify-content: flex-start;
            }

            p {
                -webkit-margin-after: 0px;
                -webkit-margin-before: 0px;
                font-size: 14px;
                color: #7F828B;
                line-height: 21px;
                margin-bottom: 4px;
            }

            a {
                font-size: 14px;
                color: #1e2530;
                line-height: 1.71;
                letter-spacing: 1px;
                text-transform: uppercase;
                font-weight: bold;
            }

            a:hover, a:active, a:focus {
                color: #f26326;
                text-decoration: none;
            }

            h1, h2, h3, h4, h5, h6 {
                font-weight: normal;
                margin: 0;
            }

            .heading-1 {
                font-size: 48px;
                font-weight: bold;
                line-height: 1.25;
                color: #1e2530;
            }

            img {
                max-width: 100%;
                height: auto;
            }

            .flex {
                display: -webkit-box;
                display: -ms-flexbox;
                display: flex;
            }

            .flex-row-col-768 {
                -webkit-box-orient: horizontal;
                -webkit-box-direction: normal;
                -ms-flex-direction: row;
                flex-direction: row;
            }

            .flex-row-col-991 {
                -webkit-box-orient: horizontal;
                -webkit-box-direction: normal;
                -ms-flex-direction: row;
                flex-direction: row;
            }

            .flex-1 {
                -webkit-box-flex: 1;
                -ms-flex: 1;
                flex: 1;
            }

            .flex-column {
                -webkit-box-orient: vertical;
                -webkit-box-direction: normal;
                -ms-flex-direction: column;
                flex-direction: column;
            }

            .flex-basis-48 {
                flex-basis: 48%;
            }

            .flex-basis-32 {
                flex-basis: 32%;
            }

            .full-width {
                width: 100%;
            }

            .text-align-right {
                text-align: right;
            }

            .align-items-center {
                -webkit-box-align: center;
                -ms-flex-align: center;
                align-items: center;
            }

            .align-items-flex-end {
                -webkit-box-align: flex-end;
                -ms-flex-align: flex-end;
                align-items: flex-end;
            }

            .justify-content-evenly {
                justify-content: space-evenly;
            }

            .justify-content-space-between {
                justify-content: space-between;
            }

            .justify-content-center {
                -webkit-box-pack: center;
                -ms-flex-pack: center;
                justify-content: center;
            }

            .justify-content-flex-end {
                justify-content: flex-end;
            }

            .padding-30 {
                padding: 30px;
            }

            .no-margin {
                margin: 0;
            }

            .ml-mr-10 {
                margin: 0 10px;
            }

            .ml-15 {
                margin-left: 15px;
            }

            .mr-10 {
                margin-right: 10px;
            }

            .mr-30 {
                margin-right: 30px;
            }

            .mr-60 {
                margin-right: 60px;
            }

            .mb-10 {
                margin-bottom: 10px;
            }

            .mb-20 {
                margin-bottom: 20px;
            }

            .mb-30 {
                margin-bottom: 30px;
            }

            .mb-50 {
                margin-bottom: 50px;
            }

            .mb-70 {
                margin-bottom: 70px;
            }

            .mb-140 {
                margin-bottom: 140px;
            }

            .mb-200 {
                margin-bottom: 200px;
            }

            .text-color-white {
                color: #ffffff;
            }

            .text-align-center {
                text-align: center;
            }

            /* ----- Button Styling Start ----- */

            .button {
                position: relative;
                display: -ms-inline-flexbox;
                display: inline-flex;
                -webkit-box-sizing: border-box;
                box-sizing: border-box;
                -webkit-box-pack: center;
                -ms-flex-pack: center;
                justify-content: center;
                -webkit-box-align: center;
                -ms-flex-align: center;
                align-items: center;
                border-radius: 0.33rem;
                min-width: 120px;
                min-height: 44px;
                vertical-align: middle;
                text-align: center;
                -o-text-overflow: ellipsis;
                text-overflow: ellipsis;
                text-transform: uppercase;
                text-decoration: none;
                font-family: "Roboto", "Segoe UI", BlinkMacSystemFont, system-ui, -apple-system;
                font-size: 14px;
                font-weight: bold;
                overflow: hidden;
                outline: none;
                cursor: pointer;
                -webkit-transition: -webkit-box-shadow 0.2s;
                transition: -webkit-box-shadow 0.2s;
                -o-transition: box-shadow 0.2s;
                transition: box-shadow 0.2s;
                transition: box-shadow 0.2s, -webkit-box-shadow 0.2s;
                padding: 17px;
            }
            /* Overlay */
            .button:before {
                content: "";
                position: absolute;
                top: 0;
                left: 0;
                background-color: rgb(255, 255, 255);
                opacity: 0;
                -webkit-transition: opacity 0.2s;
                -o-transition: opacity 0.2s;
                transition: opacity 0.2s;
            }
            .button:hover:before {
                opacity: 0.08;
            }
            .button:focus:before {
                opacity: 0.24;
            }
            .button:hover:focus:before {
                opacity: 0.3;
            }

            .button:active:after {
                opacity: 0.32;
                -webkit-transform: translate(-50%, -50%) scale(0);
                -ms-transform: translate(-50%, -50%) scale(0);
                transform: translate(-50%, -50%) scale(0);
                -webkit-transition: -webkit-transform 0s;
                transition: -webkit-transform 0s;
                -o-transition: transform 0s;
                transition: transform 0s;
                transition: transform 0s, -webkit-transform 0s;
            }

            /* ----- Primary Button Start ----- */

            .button--primary {
                border: none;
                color: rgb(255, 255, 255);
                background-color: #f26326;
                -webkit-box-shadow: 0 2px 12px -6px #cc292f;
                box-shadow: 0 2px 12px -6px #cc292f;
            }
            /* Hover, Focus */
            .button--primary:hover, .button--primary:focus {
                color: rgb(255, 255, 255);
                -webkit-box-shadow: 0 2px 16px -6px #cc292f;
                box-shadow: 0 2px 16px -6px #cc292f;
            }
            /* Active */
            .button--primary:active {
                -webkit-box-shadow: 0 6px 20px -6px #cc292f;
                box-shadow: 0 6px 20px -6px #cc292f;
            }
            /* Ripple */
            .button--primary:after {
                content: "";
                position: absolute;
                left: 50%;
                top: 50%;
                border-radius: 50%;
                width: 20rem; /* Safari */
                height: 20rem; /* Safari */
                background-color: rgb(255, 255, 255);
                opacity: 0;
                -webkit-transform: translate(-50%, -50%) scale(1);
                -ms-transform: translate(-50%, -50%) scale(1);
                transform: translate(-50%, -50%) scale(1);
                -webkit-transition: opacity 1s, -webkit-transform 0.5s;
                transition: opacity 1s, -webkit-transform 0.5s;
                -o-transition: opacity 1s, transform 0.5s;
                transition: opacity 1s, transform 0.5s;
                transition: opacity 1s, transform 0.5s, -webkit-transform 0.5s;
            }

            /* ----- Primary Button End ----- */

            /* ----- Underline Button Start ----- */

            .button-underline {
                font-size: 14px;
                font-weight: bold;
                line-height: 1.71;
                letter-spacing: 0.5px;
                color: #f26326;
                text-decoration: underline;
            }

            .button-underline:hover {
                text-decoration: underline;
                filter: brightness(90%);
            }

            .button-underline--icon {
                font-size: 12px;
                -o-transition: transform .3s;
                transition: transform .3s, -webkit-transform .3s;
                -webkit-transition: -webkit-transform .3s;
                transition: transform .3s;
            }

            .button-underline:hover .button-underline--icon {
                -webkit-transform: translateX(20px);
                -ms-transform: translateX(20px);
                transform: translateX(20px);
            }

            /* ----- Underline Button End ----- */

            /* ----- Button Styling End ----- */

            .header-info-container__hostname {
                font-size: 14px;
                font-weight: bold;
                line-height: 1.71;
                letter-spacing: 0.5px;
                color: #f26326;
            }

            .whats-next__info-container {
                max-width: 350px;
            }

            .mobile-nav {
                display: none;
            }

            .ideas-section__card {
                min-height: 450px;
                padding: 30px;
                box-shadow: 0 2px 4px 0 rgba(0, 0, 0, 0.1);
            }

            .ideas-section-card__heading {
                font-size: 18px;
                font-weight: bold;
                line-height: 1.33;
                color: #1e2530;
            }

            .ideas-section-card__icon {
                color: #f26326;
                font-size: 16px;
            }

            .footer {
                height: 300px;
                background-color: #1e2530;
            }

            .footer__icon-container {
                width: 36px;
                height: 36px;
                background-color: #ffffff;
                border-radius: 50%;
            }

            .footer__icon {
                color: #f26326;
                font-size: 18px;
            }

            .footer__link {
                font-size: 14px;
                letter-spacing: 0.5px;
                font-weight: normal;
                -o-transition: color .3s;
                -webkit-transition: color .3s;
                transition: color .3s;
                text-transform: capitalize;
            }

            .footer__link:hover {
                color: #f26326;
            }

            .nav__hamburger {
                font-size: 24px;
            }

            .navigation-container {
                display: flex;
                justify-content: flex-end;
            }

            .navigation {
                display: flex;
                align-items: center;
            }

            .nav-item__link {
                margin-left: 60px;
            }

            .small-link {
                font-size: 12px;
                text-transform: capitalize;
                color: #999999;
                text-decoration:underline;
            }

            .go-premium-section__button {
                min-width: 160px;
            }

            .go-premium-section__paragraph {
                width: 60%;
                margin: auto;
            }

            @media screen and (max-width: 991px) {
                .navigation {
                    justify-content: center;
                    align-items: center;
                    width: 100%;
                }
                .nav-item__link {
                    margin-left: 0;
                    margin-top: 30px;
                }
                .header {
                    margin-bottom: 60px;
                }
                .whats-next {
                    margin-bottom: 60px;
                }
                .heading-1 {
                    font-size: 36px;
                }
                .ideas-section {
                    margin-bottom: 20px;
                }
                .ideas-section__card {
                    margin: 0 auto 50px auto;
                    width: 60%;
                }
                .go-premium-section__paragraph {
                    width: 100%;
                }
                .flex-row-col-991 {
                    -webkit-box-orient: vertical;
                    -webkit-box-direction: normal;
                    -ms-flex-direction: column;
                    flex-direction: column;
                }
            }

            @media screen and (max-width: 768px) {
                .navigation {
                    justify-content: center;
                    align-items: center;
                    width: 100%;
                }
                .nav-item__link {
                    margin-left: 0;
                    margin-top: 20px;
                }
                .header-navigation {
                    margin-bottom: 30px;
                }
                .header-info-container {
                    text-align: center;
                }
                .heading-1 {
                    font-size: 36px;
                }
                .header {
                    margin-bottom: 100px;
                }
                .whats-next {
                    align-items: center;
                    margin-bottom: 60px;
                }
                .whats-next__info-container {
                    order: 2;
                    text-align: center;
                }
                .whats-next__corgi {
                    order: 1;
                    text-align: center;
                    margin-bottom: 20px;
                }
                .ideas-section {
                    margin-bottom: 30px;
                }
                .ideas-section__card {
                    margin: 0 auto 30px auto;
                    width: 75%;
                }
                .footer__logo {
                    margin: 0 0 20px 0;
                }
                .go-premium-section {
                    margin-bottom: 30px;
                }
                .flex-row-col-768 {
                    -webkit-box-orient: vertical;
                    -webkit-box-direction: normal;
                    -ms-flex-direction: column;
                    flex-direction: column;
                }
            }
            @media screen and (max-width: 480px) {
                .heading-1 {
                    font-size: 32px;
                }
                .ideas-section__card {
                    width: 100%;
                    margin-bottom: 30px;
                }
            }
        </style>
    </head>
    <body class="">
        <div class="container padding-30">
            <nav class="header-navigation navbar navbar-expand-lg mb-70">
                <a href="https://www.octenium.com/" target="_blank" class="navbar-brand"><img
                        src="https://panel.octenium.com/ress/img/logo.png"
                        alt="Octenium" width="180"></a>
                <button class="nav__hamburger navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false">
                    <span class="navbar-toggler-icon flex align-items-center justify-content-center">
                        <i class="fa fa-bars" aria-hidden="true"></i>
                    </span>
                </button>
                <div class="collapse navbar-collapse navigation-container" id="navbarSupportedContent">
                    <ul class="navbar-nav navigation">
                        <li class="nav-item"><a href="https://support.octenium.com/?utm_source=octeniumapp&utm_campaign=support_link&utm_medium=welcome_page&utm_content=header_menu" class="nav-item__link nav-link" target="_blank">Documentation</a></li>
                        <li class="nav-item"><a href="https://panel.octenium.com/signin?utm_source=octeniumapp&utm_campaign=login_link&utm_medium=welcome_page&utm_content=header_menu" class="nav-item__link nav-link" target="_blank">Se connecter</a></li>
                        <li class="nav-item"><a href="https://panel.octenium.com/signup?utm_source=octeniumapp&utm_campaign=signup_link&utm_medium=welcome_page&utm_content=header_menu" class="nav-item__link nav-link" target="_blank">S'enregistrer</a></li>
                    </ul>
                </div>
            </nav>
            <div class="header flex flex-row-col-768 justify-content-space-between align-items-center mb-200">
                <div class="header-corgi-container flex-basis-48 mb-20">
                    <img src="https://cdn.octenium.com/media/build-icon.png" alt="Premier pas">
                </div>
                <div class="header-info-container flex flex-column flex-basis-48">
                    <p class="header-info-container__welcome-txt heading-1 mb-20">Bravo ! Votre hébergement web est activé !</p>
                    <p class="mb-50">Vous voyez cette page car votre site Web n'a pas de fichier &quot;<strong>index.php</strong>&quot; ou &quot;<strong>index.html</strong>&quot; dans le repertoire <strong>public_html</strong>.</p>
                    <a href="https://support.octenium.com/kb/comment-se-connecter-a-cpanel/" class="header-info-container__button button-underline">Se connecter au cPanel <i class="fa fa-chevron-right ml-15 button-underline--icon" aria-hidden="true"></i></a>
                </div>
            </div>
            <div class="ideas-section flex flex-row-col-768 flex-row-col-991 justify-content-space-between mb-140">
                <div class="flex-basis-32 justify-content-space-between ">
                    <div class="ideas-section__card flex flex-column">
                        <div class="">
                            <h3 class="ideas-section-card__heading flex align-items-center mb-20"><i class="fa fa-picture-o ideas-section-card__icon mr-10"></i> Installer Wordpress ?</h3>
                            <p class="mb-30">Installez votre site Wordpress en un clic en toute simplicité avec des outils de dernière génération.</p>
                            <a href="https://support.octenium.com/kb/comment-installer-wordpress-sur-un-hebergement-cpanel/" class="button-underline" target="_blank" rel="nofollow">En savoir plus... <i class="fa fa-chevron-right ml-15 button-underline--icon" aria-hidden="true"></i></a>
                        </div>
                        <div class="flex align-items-flex-end justify-content-center flex-1">
                            <img src="https://cdn.octenium.com/media/wordpress.png" alt="Wordpress" style="max-height: 200px;">
                        </div>
                    </div>
                </div>
                <div class="flex-basis-32">
                    <div class="ideas-section__card flex flex-column">
                        <div class="">
                            <h3 class="ideas-section-card__heading flex align-items-center mb-20"><i class="fa fa-cloud-upload ideas-section-card__icon mr-10"></i> Téléchargez votre site Web ?</h3>
                            <p class="mb-30">Téléchargez les fichiers de votre site Web à l'aide du gestionnaire de fichiers en ligne rapide ou faites-le via FTP.</p>
                            <a href="https://support.octenium.com/kb/comment-utiliser-le-gestionnaire-de-fichiers-dans-cpanel/" class="button-underline" target="_blank">En savoir plus... <i class="fa fa-chevron-right ml-15 button-underline--icon" aria-hidden="true"></i></a>
                        </div>
                        <div class="flex align-items-flex-end justify-content-center flex-1">
                            <img src="https://cdn.octenium.com/media/cloud-upload.png" alt="E-mail" style="max-height: 200px;">
                        </div>
                    </div>
                </div>
                <div class="flex-basis-32">
                    <div class="ideas-section__card flex flex-column">
                        <div class="">
                            <h3 class="ideas-section-card__heading flex align-items-center mb-20"><i class="fa fa-flask ideas-section-card__icon mr-10"></i> Créer des boites E-mail ?</h3>
                            <p class="mb-30">Créez des boites E-mail profesionnelles et commencez à communiquer avec vos clients dès maintenant.</p>
                            <a href="https://support.octenium.com/kb/comment-creer-une-adresse-e-mail-dans-cpanel/" class="button-underline" target="_blank">En savoir plus... <i class="fa fa-chevron-right ml-15 button-underline--icon" aria-hidden="true"></i></a>
                        </div>
                        <div class="flex align-items-flex-end justify-content-center flex-1">
                            <img src="https://cdn.octenium.com/media/email-icon.png" alt="E-mail" style="max-height: 200px;">
                        </div>
                    </div>
                </div>
            </div>
            <div class="go-premium-section flex flex-column align-items-center justify-content-center mb-140">
                <div class="text-align-center mb-30">
                    <p class="heading-1 mb-10">Besoin de support technique ?</p>
                    <p class="go-premium-section__paragraph">Un agent d'assistance vous attend, il vous suffit juste de créer un ticket de supoort dans votre espace client.</p>
                </div>
                <a href="https://panel.octenium.com/tickets/" class="go-premium-section__button button button--primary no-margin mb-20" target="_blank">Créer un ticket de support</a>
            </div>
        </div>
        <footer class="footer full-width flex flex-column justify-content-center align-items-center">
            <div class="mb-70 flex flex-column align-items-center">
                <p class="mb-30 text-color-white">Suivez-nous sur les réseaux sociaux :</p>
                <div class="flex">
                    <a href="https://www.facebook.com/octenium/" target="_blank" class="footer__icon-container flex justify-content-center align-items-center ml-mr-10">
                        <i class="footer__icon fa fa-facebook-f"></i>
                    </a>
                    <a href="https://twitter.com/octenium" target="_blank" class="footer__icon-container flex justify-content-center align-items-center ml-mr-10">
                        <i class="footer__icon fa fa-twitter"></i>
                    </a>
                </div>
            </div>
            <div class="flex flex-row-col-768 align-items-center justify-content-center">
                <p class="text-color-white">Hébergé par <a href="https://www.octenium.com/" class="footer__link text-color-white" target="_blank" rel="noopener">Octenium</a>.</p>
            </div>
        </footer>
        <!-- Fontawesome -->
        <script src="https://use.fontawesome.com/ee069c3df0.js"></script>
  </body>
</html>
