#!/bin/bash

set -euo pipefail
shopt -s inherit_errexit

if [[ -f /opt/oct-installer/.application-installed ]]; then
	echo "Application script completion detected - not re-running"
	exit 0
fi

. /opt/oct-installer/common.sh

########
echo "Disable unattended upgrades while configuring app"
########
toggle_unattended_upgrades "disable"

########
echo "Install Coolify"
########
# replace this with manual steps outlined : https://coolify.io/docs/installation#manually
curl -fsSL https://cdn.coollabs.io/coolify/install.sh | bash -

########
echo "Re-enable unattended upgrades as app is configured"
########
toggle_unattended_upgrades "enable"
cleanup_imageless
