#!/bin/bash

set -euo pipefail
shopt -s inherit_errexit

https_conf="/etc/nginx/sites-available/{{APP}}_https.conf"
cockpit_nginx_conf="/etc/nginx/sites-available/cockpit.conf"
cockpit_conf="/etc/cockpit/cockpit.conf"

certbot_settings=""
if certbot_settings="$(grep 'managed\ by\ Certbot$' "${https_conf}" 2>&1)" && [[ -n "${certbot_settings}" ]]; then
	server_name="$(awk '/^[[:blank:]]*server_name/ {print $2}' <<< "${certbot_settings}")"
	cert_file="$(awk '/^[[:blank:]]*ssl_certificate[[:blank:]]/ {print $2}' <<< "${certbot_settings}")"
	cert_key_file="$(awk '/^[[:blank:]]*ssl_certificate_key[[:blank:]]/ {print $2}' <<< "${certbot_settings}")"

	server_name="${server_name::-1}"
	cert_file="${cert_file::-1}"
	cert_key_file="${cert_key_file::-1}"

	if [[ -f "${cert_file}" && -f "${cert_key_file}" ]]; then
		sed -i \
			-e "s/https:\/\/.*:\([[:digit:]]\{1,6\}\) wss:\/\/.*:\([[:digit:]]\{1,6\}\)$/https:\/\/${server_name}:\1 wss:\/\/${server_name}:\2/" \
			"${cockpit_conf}"

		sed -i \
			-e "/^[[:blank:]]*server_name[[:blank:]]/ s/[[:blank:]]_/ ${server_name}/" \
			-e "/^[[:blank:]]*ssl_certificate[[:blank:]]/ s/\/etc\/nginx\/ssl\/server\.crt/${cert_file//"/"/"\/"}/" \
			-e "/^[[:blank:]]*ssl_certificate_key[[:blank:]]/ s/\/etc\/nginx\/ssl\/server\.key/${cert_key_file//"/"/"\/"}/" \
			"${cockpit_nginx_conf}"

		systemctl reload nginx.service
	fi
fi